import ctypes
import os

imagePlayerProperty_minPitchHZ=1
imagePlayerProperty_octiveCount=2
imagePlayerProperty_imageFadeLengthMS=3
imagePlayerProperty_reverseBrightness=4
imagePlayerLibPath=os.path.join(os.path.dirname(__file__),'imagePlayer.dll')

ipLib=None
ipHandle=None

def initialize(sampleRate,width,height):
	global ipLib, ipHandle
	ipLib=ctypes.cdll.LoadLibrary(imagePlayerLibPath)
	ipHandle=ipLib.imagePlayer_initialize(sampleRate,width,height)

def getProperty(prop):
	return ipLib.imagePlayer_getProperty(ipHandle,prop)

def setProperty(prop,val):
	ipLib.imagePlayer_setProperty(ipHandle,prop,val)

def setNewImage(image):
	ipLib.imagePlayer_setNewImage(ipHandle,image)

def terminate():
	ipLib.imagePlayer_terminate(ipHandle)
