import ctypes
import globalPluginHandler
import touchHandler
import screenBitmap
import screenExplorer
import imagePlayer
import textInfos
import ui

class ScreenBitmapWithGrey(screenBitmap.ScreenBitmap):

	def captureImage(self,x,y,w,h,grey=False):
		buffer=super(ScreenBitmapWithGrey,self).captureImage(x,y,w,h)
		if not grey:
			return buffer
		else:
			greyBuffer=(ctypes.c_ubyte*self.width*self.height)()
			for i in xrange(self.width):
				for j in xrange(self.height):
					p=screenBitmap.rgbPixelBrightness(buffer[j][i])
					greyBuffer[j][i]=p
			return greyBuffer

class ScreenExplorerWithAudio(screenExplorer.ScreenExplorer):

	audioImageWidth=24
	audioImageHeight=24
	isAudioInitialized=False

	def initAudio(self):
		imagePlayer.initialize(22050,self.audioImageHeight,self.audioImageHeight)
		self.isAudioInitialized=True
		imagePlayer.setProperty(imagePlayer.imagePlayerProperty_minPitchHZ,110)
		imagePlayer.setProperty(imagePlayer.imagePlayerProperty_octiveCount,6)
		self.sb=ScreenBitmapWithGrey(self.audioImageHeight,self.audioImageHeight)

	def terminateAudio(self):
		imagePlayer.terminate()
		self.isAudioInitialized=False

	def __del__(self):
		if self.isAudioInitialized:
			self.terminateAudio()

	def moveTo(self,x,y,new=False,unit=textInfos.UNIT_LINE):
		if not new and self.isAudioInitialized:
			x=x-(self.audioImageWidth/2)
			y=y-(self.audioImageHeight/2)
			buffer=self.sb.captureImage(x,y,self.audioImageWidth,self.audioImageHeight,True)
			imagePlayer.setNewImage(buffer)
		super(ScreenExplorerWithAudio,self).moveTo(x,y,new,unit)

class GlobalPlugin(globalPluginHandler.GlobalPlugin):

	def __init__(self):
		if touchHandler.handler:
			touchHandler.handler.screenExplorer=ScreenExplorerWithAudio()
			touchHandler.handler.screenExplorer.initAudio()
		super(GlobalPlugin,self).__init__()

	def script_toggleAudioScreen(self,gesture):
		if not touchHandler.handler:
			ui.message("Touch not available")
			return
		if touchHandler.handler.screenExplorer.isAudioInitialized:
			touchHandler.handler.screenExplorer.terminateAudio()
			ui.message("audioScreen off")
		else:
			touchHandler.handler.screenExplorer.initAudio()
			ui.message("audioScreen on")
	script_toggleAudioScreen.__doc__="Switches audioScreen on and off"

	def script_toggleBrightness(self,gesture):
		if not touchHandler.handler or not touchHandler.handler.screenExplorer.isAudioInitialized:
			ui.message("Audio Screen not running")
			return
		rb=(imagePlayer.getProperty(imagePlayer.imagePlayerProperty_reverseBrightness)+1)%2
		if rb:
			ui.message("Dark on light")
		else:
			ui.message("Light on dark")
		imagePlayer.setProperty(imagePlayer.imagePlayerProperty_reverseBrightness,rb)
	script_toggleBrightness.__doc__="Toggles between light on dark, and dark on light"

	def script_hoverUp(self,gesture):
		imagePlayer.setNewImage(None)

	__gestures={
		"ts:hoverUp":"hoverUp",
		"kb:NVDA+a":"toggleBrightness",
		"kb:NVDA+Control+a":"toggleAudioScreen",
	}

 